# IDE Setup

## Eclipse

Start with the Eclipse IDE for Embmedded C/C++ Developers, it comes with various tools that are appropriate for embedded development, such as debugger plugins.

As of 2021/08/31 the latest version of Eclipse (4.20 / aka 2021-06) is available here:

https://www.eclipse.org/downloads/packages/release/2021-06/r/eclipse-ide-embedded-cc-developers

Install it, then add the Rust Corrosion plugin from the 'Eclipse Marketplace' via the menus inside Eclipse.

## Settings

### Disable launch bar

The launch bar is a giant toolbar that gets in the way of all the usual Eclipse icons and is installed and enabled by default when installing the Embedded C/C++ Distribution.  To disable it, go into Eclipse preferences, and go to `Run/Debug` -> `Launching` -> `Launch Bar` and untick `Enable the Launch Bar`.

## Rust setup

Go into Eclipse preferences, and go to `Rust`.

If Eclipse is giving an error prompt about `Input a valid path to the Rust Language Server (rls)' then click `Download rust-analyzer`.

View the Eclipse "Error Log" and delete all events, restart Eclipse.  Ensure that the Error log is empty upon restart.
(Details: https://github.com/eclipse/corrosion/issues/130)

## Editor setup

Go into Eclipse preferences, and go to `General` -> `Editors` -> `Text Editors`.

Set displayed tab with to 4.
Click `Insert spaces for tabs`.

Apply and Close.

Then from the menus, select `Window` -> `Editor` -> `Show whitespace characters`. So that it is ENABLED.

# Character Encoding

All project files should be set to use the `UTF-8` character encoding.  In Eclipse, for each project right click the project in the Project Explorer view, then click `Properties` -> `Resource` -> `Text File Encoding` -> `Other` -> `UTF-8`.
